/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.condition.ActiveDebuffConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.DistanceConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.EquipmentConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.ExplodeConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.HasAggroConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.HeadshotConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.NoConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.NoDamageGivenConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.NoDamageTakenConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.NoFoodConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.NoHealConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.common.quests.condition.SimpleProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.SpecificWeaponConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.UniqueMobKillsConditionProvider;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class QuestConditions {
    private static final Map<ResourceLocation, QuestConditionProviderType<?>> MAP = new HashMap();
    public static final QuestConditionProviderType<NoConditionProvider> NO_CONDITION_TYPE = QuestConditions.register("empty", SimpleProviderSerializer.withConstantResult(() -> NoConditionProvider.NO_CONDITION), (QuestConditionProviderType<Q> type, CompoundNBT nbt) -> NoConditionProvider.NO_CONDITION, false, new Trigger[0]);

    public static <Q extends IQuestConditionProvider<?>> QuestConditionProviderType<Q> register(ResourceLocation location, IQuestConditionProviderSerializer<Q> serializer, BiFunction<QuestConditionProviderType<Q>, CompoundNBT, Q> fromNbtReader, boolean failsQuest, Trigger ... triggers) {
        QuestConditionProviderType<Q> type = new QuestConditionProviderType<Q>(location, serializer, fromNbtReader, failsQuest, triggers);
        MAP.put(location, type);
        return type;
    }

    public static <Q extends IQuestConditionProvider<?>> QuestConditionProviderType<Q> getByKey(ResourceLocation key) {
        return MAP.get(key);
    }

    public static <C extends IQuestCondition> CompoundNBT saveConditionToNbt(C condition) {
        CompoundNBT nbt = new CompoundNBT();
        IQuestConditionProvider<?> provider = condition.getProviderType();
        nbt.func_74778_a("type", provider.getType().getId().toString());
        provider.saveInternalData(nbt);
        condition.saveData(nbt);
        return nbt;
    }

    public static <C extends IQuestCondition, P extends IQuestConditionProvider<C>> C getConditionFromNbt(CompoundNBT nbt) {
        ResourceLocation questTypeId = new ResourceLocation(nbt.func_74779_i("type"));
        QuestConditionProviderType type = QuestConditions.getByKey(questTypeId);
        Object provider = type.fromNbt(nbt);
        Object condition = provider.makeConditionInstance();
        condition.loadData(nbt);
        return condition;
    }

    private static <Q extends IQuestConditionProvider<?>> QuestConditionProviderType<Q> register(String id, IQuestConditionProviderSerializer<Q> serializer, BiFunction<QuestConditionProviderType<Q>, CompoundNBT, Q> fromNbtReader, boolean failsQuest, Trigger ... triggers) {
        return QuestConditions.register(GunsRPG.makeResource(id), serializer, fromNbtReader, failsQuest, triggers);
    }

    static {
        QuestConditions.register("used_item", new SpecificWeaponConditionProvider.Serializer(), SpecificWeaponConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
        QuestConditions.register("debuff", new ActiveDebuffConditionProvider.Serializer(), ActiveDebuffConditionProvider::fromNbt, false, Trigger.TICK, Trigger.ENTITY_KILLED);
        QuestConditions.register("no_food", SimpleProviderSerializer.withResultOf(NoFoodConditionProvider::new), NoFoodConditionProvider::fromNbt, true, Trigger.TICK);
        QuestConditions.register("no_heal", SimpleProviderSerializer.withResultOf(NoHealConditionProvider::new), NoHealConditionProvider::fromNbt, true, Trigger.TICK);
        QuestConditions.register("explode", SimpleProviderSerializer.withResultOf(ExplodeConditionProvider::new), ExplodeConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
        QuestConditions.register("equipment", new EquipmentConditionProvider.Serializer(), EquipmentConditionProvider::fromNbt, false, Trigger.TICK, Trigger.ENTITY_KILLED);
        QuestConditions.register("aggro", new HasAggroConditionProvider.Serializer(), HasAggroConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
        QuestConditions.register("distance", new DistanceConditionProvider.Serializer(), DistanceConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
        QuestConditions.register("no_damage_taken", SimpleProviderSerializer.withResultOf(NoDamageTakenConditionProvider::new), NoDamageTakenConditionProvider::fromNbt, true, Trigger.DAMAGE_TAKEN);
        QuestConditions.register("no_damage_given", SimpleProviderSerializer.withResultOf(NoDamageGivenConditionProvider::new), NoDamageGivenConditionProvider::fromNbt, true, Trigger.DAMAGE_GIVEN);
        QuestConditions.register("is_headshot", new HeadshotConditionProvider.Serializer(), HeadshotConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
        QuestConditions.register("unique", SimpleProviderSerializer.withResultOf(UniqueMobKillsConditionProvider::new), UniqueMobKillsConditionProvider::fromNbt, false, Trigger.ENTITY_KILLED);
    }
}

